using UnityEngine;
using UnityEngine.Networking;
using System.Collections;

/// <summary>
/// A simple HTTP client for making GET requests using UnityWebRequest.
/// </summary>
public class HTTPClient : MonoBehaviour
{
    /// <summary>
    /// Sends a GET request to the specified URL and handles the response.
    /// </summary>
    /// <param name="url">The URL to send the GET request to.</param>
    /// <param name="onSuccess">Callback invoked with the response text if the request is successful.</param>
    /// <param name="onError">Optional callback invoked with an error message if the request fails.</param>
    /// <returns>An IEnumerator for coroutine execution.</returns>
    public IEnumerator GetRequest(string url, System.Action<string> onSuccess, System.Action<string> onError = null)
    {
        using UnityWebRequest request = UnityWebRequest.Get(url);
        yield return request.SendWebRequest();
        if (request.result == UnityWebRequest.Result.Success)
            onSuccess?.Invoke(request.downloadHandler.text);
        else
            onError?.Invoke($"Error: {request.responseCode} - {request.error}");
    }
}